#!/bin/bash

#taken from
#http://www.howtogeek.com/175008/the-non-beginners-guide-to-syncing-data-with-rsync/


#copy old time.txt to time2.txt

yes | cp ~/backup/time.txt ~/backup/time2.txt

#overwrite old time.txt file with new time

echo `date +"%a %d %b %Y %H_%M%p"` > ~/backup/time.txt

#make the log file

echo “” > ~/backup/rsync-`date +"%a %d %b %Y %H_%M%p"`.log

#rsync command

rsync -avzhPR --chmod=Du=rwx,Dgo=rx,Fu=rw,Fgo=r --delete --stats --log-file=~/backup/rsync-`date +"%a %d %b %Y %H_%M%p"`.log --link-dest=/home/john/RSYNC-BACKUPS/`cat ~/backup/time2.txt` /home/john/chalmers/ /home/john/RSYNC-BACKUPS/`date +”%F-%I%p”`/

#don’t forget to scp the log file and put it with the backup

scp -P 12345 ~/backup/rsync-`cat ~/backup/time.txt`.log /home/john/RSYNC-BACKUPS/`cat ~/backup/time.txt`/rsync-`cat ~/backup/time.txt`.log

